# -*- coding: utf-8 -*-
from ladon.ladonizer import ladonize
from ladon.types.ladontype import LadonType
import json
from mysite.personnel.models.model_area import Area
from mysite.personnel.models.model_areaadmin import AreaAdmin
from django.contrib.auth.models import User
from mysite import utils
from mysite.utils import get_option
#from base.middleware import threadlocals
RET_INFO={}
class AreaService(object):
    u"""
    【区域操作】区域新增/更新、删除操作
    """
    @ladonize(str,str,rtype=str)
    def SetArea(self,area_info,operation):
        """
        新增/更新区域操作
        @param area_info:参数一 区域相关信息 格式{"id":"区域ID","areaid":"区域编号","areaname":"区域名称","parent":"父区域ID","remark":"备注"}
        @param operation:参数二 表示操作类型 'add':新增,'edit':编辑
        @rtype: 返回执行结果信息
              0 - 操作成功
            -71 - area_info数据错误
            -72 - 区域编号不能为空
            -73 - 区域名称不能为空
            -74 - 上级区域不存在
            -75 - 上级区域不能为该区域,
            -76 - 编辑区域不存在,
            -77 - 区域编号重复,
            -78 - 上级区域不能为自己的子区域,
            -79 - 根区域不能有上级区域
            -80 - 保存授权区域失败
        """
        RET_INFO['op']='SetArea'
        RET_INFO['data']={}
        try:
            area=utils.loads(area_info)        #格式化数据
            id=area['id']
            areaid=area['areaid']
            areaname=area['areaname']
            parent_id=area['parent']
            remark=area['remark']
        except:
            RET_INFO['ret']='-71'
            RET_INFO['id']=''
            return json.dumps(RET_INFO)
        if areaid=='':                        #判断区域编号是否为空
            RET_INFO['ret']='-72'
            RET_INFO['id']=id
            return json.dumps(RET_INFO)
        if areaname=='':                      #判断区域名称是否为空
            RET_INFO['ret']='-73'
            RET_INFO['id']=id
            return json.dumps(RET_INFO)
        if parent_id!='':                     #判断是否添加上级区域
            try:
                parent=Area.objects.get(id__exact=parent_id)  #判断上级区域是否存在
                if id==parent_id:    #限制不能设置一个区域的上级区域为其自身
                    RET_INFO['ret']='-75'
                    RET_INFO['id']=id
                    return json.dumps(RET_INFO)
                if id=='1':                  #根区域不能有上级区域
                    RET_INFO['ret']='-79'
                    RET_INFO['id']=id
                    return json.dumps(RET_INFO)
            except:
                RET_INFO['ret']='-74'
                RET_INFO['id']=id
                return json.dumps(RET_INFO)
        else:
            parent=None
        if operation=='edit': #编辑区域
            try:
                old_area=Area.objects.get(id__exact=id) #判断所编辑的区域是否存在
            except:
                RET_INFO['ret']='-76'
                RET_INFO['id']=id
                return json.dumps(RET_INFO)
            if areaid!=old_area.areaid:             #判断区域编号是否改变
                try:
                    a=Area.objects.get(areaid__exact=areaid)   #判断编号是否存在
                    RET_INFO['ret']='-77'
                    RET_INFO['id']=id
                    return json.dumps(RET_INFO)
                except:
                    pass
            if parent_id!='':
                if old_area in parent.parents():    #限制不能设置一个区域的上级区域为子区域
                    RET_INFO['ret']='-78'
                    RET_INFO['id']=id
                    return json.dumps(RET_INFO)
            old_area.areaid=areaid
            old_area.areaname=areaname
            old_area.parent=parent
            old_area.remark=remark
#            old_area.save()
            super(Area,old_area).save()
            RET_INFO['ret']='0'
            RET_INFO['id']=id
            return json.dumps(RET_INFO)
        elif operation=='add':    #新增区域
            try:
                a=Area.objects.get(areaid__exact=areaid)    #判断编号是否重复
                RET_INFO['ret']='-77'
                RET_INFO['id']=id
                return json.dumps(RET_INFO)
            except:
                a=Area(id=id,areaid=areaid,areaname=areaname,parent=parent,remark=remark)
                super(Area,a).save()          #使用a.save()会报错，详见Area下的save()方法
                area=Area.objects.get(areaid__exact=areaid)
                #login_user = threadlocals.get_current_user()                 #获取当前用户
                login_user=User.objects.get(id__exact=1)                      #联调使用
                try:    #如果当前用户存在，该用户非超级管理员，用户的授权区域大于0，设置该区域为操作用户的授权区域
                    if login_user and not login_user.is_superuser and AreaAdmin.objects.filter(user__exact = login_user).count()>0:
                        obj_ua = AreaAdmin()
                        obj_ua.area=a
                        obj_ua.user = login_user
                        obj_ua.save()
                except:
                    area.delete()      #如果保存授权区域失败，删除之前保存的区域
                    RET_INFO['ret']='-80'
                    RET_INFO['id']=area.id
                    return json.dumps(RET_INFO)
                RET_INFO['ret']='0'
                RET_INFO['id']=area.id
                return json.dumps(RET_INFO)
    @ladonize(str,rtype=str)
    def DeleteArea(self,ids):
        """
        删除区域
        @param ids: 参数一  区域ID  id1,id2,id3..
        @rtype:返回执行结果信息
              0 - 操作成功
            -81 - 该区域还有下级子区域，不能删除
            -82 - 该区域还有设备，不能删除
            -83 - 该区域还有人员，不能删除
            -84 - 该区域中已包含电子地图，不能删除
            -85 - 根区域不能删除
            -86 - 操作区域不存在
            -87 - 删除区域ID不能为空
        """
        RET_INFO['op']='DeleteArea'
        RET_INFO['data']={}
        if ids=='':                                     #判断id是否为空
            RET_INFO['ret']='-87'
            RET_INFO['id']=ids
            return json.dumps(RET_INFO)
        area_ids=ids.split(',')                         #获取id列表
        area_set=set()
        for id in area_ids:
            if id=='1':                                 #默认区域能删除
                RET_INFO['ret']='-85'
                RET_INFO['id']=id
                return json.dumps(RET_INFO)
            try:
                area=Area.objects.get(id__exact=id)            #判断区域是否存在
                if len(area.children())>0:                     #判断区域是否有子区域，存在则不能删除
                    RET_INFO['ret']='-81'
                    RET_INFO['id']=id
                    return json.dumps(RET_INFO)
                dev=Area.device_set.related.model
                if len(dev.objects.filter(area=area))>0:       #判断该区域是否有设备，存在则不能删除
                    RET_INFO['ret']='-82'
                    RET_INFO['id']=id

                    return json.dumps(RET_INFO)
                if area.employee_set.all().count()>0:          #判断该区域是否有员工，存在则不能删除
                    RET_INFO['ret']='-83'
                    RET_INFO['id']=id

                    return json.dumps(RET_INFO)
                if get_option("IACCESS"):                      #判断是否开启门禁
                    if Area.accmap_set.related.model.objects.filter(area=area).count() > 0:   #判断该区域是否有门禁，存在则不能删除
                        RET_INFO['ret']='-84'
                        RET_INFO['id']=id
                        return json.dumps(RET_INFO)
                area_set.add(area)

            except:
                RET_INFO['ret']='-86'
                RET_INFO['id']=id
                return json.dumps(RET_INFO)
        for area in area_set:
            areaadmin= Area.areaadmin_set.related.model    #获取授权区域集合
            areaadmin.objects.filter(area=area).delete()   #删除为该区域的授权区域
            area.delete()
        RET_INFO['ret']='0'
        RET_INFO['id']=ids

        return json.dumps(RET_INFO)
